/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.cec;

import com.quantumdata.cec.CECGUIPanel;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.StdConnectionManager;
import java.awt.Component;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class CECGUI
extends JApplet {
    private static final long serialVersionUID = 1L;
    private CECGUIPanel m_panel;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Quantum Data CEC Device Controller");
        jFrame.setDefaultCloseOperation(3);
        CECGUIPanel cECGUIPanel = new CECGUIPanel();
        CECGUI.init(cECGUIPanel, cECGUIPanel);
        jFrame.getContentPane().add(cECGUIPanel);
        jFrame.setSize(700, 700);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setLocationRelativeTo(null);
    }

    public void init() {
        this.m_panel = new CECGUIPanel();
        CECGUI.init(this.m_panel, this);
        this.getContentPane().add(this.m_panel);
        this.setSize(700, 500);
        this.setVisible(true);
    }

    public void stop() {
        if (this.m_panel != null) {
            this.m_panel.disconnect();
        }
        super.stop();
    }

    private static void init(CECGUIPanel cECGUIPanel, Component component) {
        try {
            UIManager.setLookAndFeel("com.quantumdata.laf.QDILookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cECGUIPanel.numMsgs = 4;
        StdConnectionManager stdConnectionManager = new StdConnectionManager(component);
        cECGUIPanel.setInstrument(CECGUI.setInstrument(stdConnectionManager));
        if (!cECGUIPanel.create()) {
            cECGUIPanel.disconnect();
        }
    }

    public static RemoteInstrument setInstrument(StdConnectionManager stdConnectionManager) {
        RemoteInstrument remoteInstrument = stdConnectionManager.newConnection();
        try {
            remoteInstrument.connect();
        }
        catch (InstrumentException instrumentException) {
            JOptionPane.showMessageDialog(new JPanel(), "*** CONNECTION FAILED: " + instrumentException.getMessage() + " ***");
            System.exit(0);
        }
        return remoteInstrument;
    }
}

